#include <stdio.h>
#include <pthread.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#define AUTO 0
#define AUTOBUS 1
#define KAMION 2

pthread_mutex_t mutex;
pthread_cond_t cond;

typedef struct{
    int id;
    int tip;
    char smer; //N kao north S kao south
}Auto;

int naMostu = 0;
char trenutniSmer = 'X';
int brAutobusa = 0;
int brKamiona = 0;

void *doWork(void *t){

    Auto *a = (Auto *)t;
    printf("Vozilo %d tipa ", a->id);
    if(a->tip == AUTO)
        printf("automobil PRILAZI NADVOZNJAKU iz smera %c\n", a->smer);
    else if(a->tip == AUTOBUS)
        printf("autobus PRILAZI NADVOZNJAKU iz smera %c\n", a->smer);
    else
        printf("kamion PRILAZI NADVOZNJAKU iz smera %c\n", a->smer);


    pthread_mutex_lock(&mutex);
    //glavna logika pristupa i cekanja
    while(((naMostu > 0 && trenutniSmer != a->smer) || (brKamiona > 0)) ||
        (a->tip == AUTOBUS && (brAutobusa > 0 || brKamiona > 0)) ||
        (a->tip == KAMION && (naMostu > 0 || brAutobusa > 0 || brKamiona > 0))
    ){
        printf("Vozilo %d tipa ", a->id);
        if(a->tip == AUTO)
            printf("automobil CEKA iz smera %c\n", a->smer);
        else if(a->tip == AUTOBUS)
            printf("autobus CEKA iz smera %c\n", a->smer);
        else
            printf("kamion CEKA iz smera %c\n", a->smer);
        
        pthread_cond_wait(&cond, &mutex);
    }

    naMostu++;
    trenutniSmer = a->smer;
    if(a->tip == AUTOBUS)
        brAutobusa = 1;
    
    if(a->tip == KAMION)
        brKamiona = 1;

    pthread_mutex_unlock(&mutex);

    printf("Vozilo %d PRELAZI iz smera %c...\n", a->id, a->smer);
    sleep(2);

    pthread_mutex_lock(&mutex);
    naMostu--;

    if(a->tip == AUTOBUS)
        brAutobusa = 0;

    if(a->tip == KAMION)
        brKamiona = 0;

    if(naMostu == 0 || a->tip == AUTOBUS || a->tip == KAMION){
        pthread_cond_broadcast(&cond);
    }

    pthread_mutex_unlock(&mutex);

    printf("Vozilo %d JE PRESLO iz smera %c...\n", a->id, a->smer);

    pthread_exit(NULL);
}

int main(){
    
    pthread_mutex_init(&mutex, NULL);
    pthread_cond_init(&cond, NULL);

    srand(time(NULL));

    int brojVozila = 15;
    pthread_t niti[brojVozila];

    for(int i = 0;i < brojVozila;i++){
        Auto *a = (Auto*)malloc(sizeof(Auto));
        a->id = i;

        
        int br = rand() % 10;
        // printf("RADNOM BROJ JE %d\n", br);
        if(br % 3 == 0)
            a->tip = AUTO;
        else if(br % 3 == 1)
            a->tip = AUTOBUS;
        else
            a->tip = KAMION;

        br = rand() % 10;
        if(br % 2 == 0)
            a->smer = 'N';
        else
            a->smer = 'S';

        pthread_create(&niti[i], NULL, doWork, a);
        //sleep da simulira prilazak u razlicitim intervalima
        sleep(i % 3);
        
        //test ako budu samo kamioni/busevi
        // a->tip = KAMION;
        // if(i % 2 == 0)
        //     a->smer = 'N';
        // else
        //     a->smer = 'S';
        // pthread_create(&niti[i], NULL, doWork, a);
        // sleep(i % 3);
    }

    for(int i = 0;i < brojVozila;i++)
        pthread_join(niti[i], NULL);

    pthread_mutex_destroy(&mutex);
    pthread_cond_destroy(&cond);

    return 0;
}